package gov.va.med.mhv.usermgmt.service;

import java.util.List;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.dto.ActivitySearchCriteriaDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;

public interface ActivityService {

	/**
	 * @param userName
	 * @param userProfileId
	 */
	boolean createLoginActivity(String userName, Long userProfileId,Boolean loginStatus);

	/**
	 * Audit update user profile details
	 *
	 * @param userProfileId
	 * @param response
	 */
	void auditUpdateProfileEvent(Long userProfileId, ActivityActorTypeEnumeration actor, ResponseUtil response);

	/**
	 * Audit registration event
	 *
	 * @param userProfile
	 * @param response
	 */
	void auditRegistrationEvent(UserProfile userProfile, ResponseUtil response);

	/**
	 * Audits MVI Match & Correlation Event
	 *
	 * @param userProfile
	 * @param actor
	 * @param successful
	 * @param activityActionType
	 * @param activityType
	 * @param response
	 */
	void auditMviEvent(
		UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ActivityActionTypeEnumeration activityActionType,
		ActivityTypeEnumeration activityType, ResponseUtil response);

	/**
	 * Audits MVI Match & Correlation Event
	 *
	 * @param userProfile
	 * @param actor
	 * @param successful
	 * @param activityActionType
	 * @param activityType
	 * @param response
	 */
	void auditMviEvent(
		UserProfile userProfile, String actor, Boolean successful, ActivityActionTypeEnumeration activityActionType, ActivityTypeEnumeration activityType,
		ResponseUtil response);

	/**
	 * @param searchCriteria
	 * @return
	 */
	void getActivitiesForSubject(ActivitySearchCriteriaDTO searchCriteria, ResponseUtil<List<ActivityDTO>> response);

	/**
	 * @param userProfile
	 * @return
	 */
	void auditAccountDeactivateEauthHashEvent(UserProfile userProfile, ResponseUtil response);

	/**
	 * @param userProfile
	 * @param actor
	 * @param successful
	 * @param activityActionType
	 * @param response
	 */
	void auditMviLoginEvent(
		UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ActivityActionTypeEnumeration activityActionType, ResponseUtil response);

	/**
	 * @param userProfile
	 * @param successful
	 * @param performer
	 * @param response
	 */
	void auditAccountUpgradeEvent(UserProfile userProfile, Boolean successful, ActivityActorTypeEnumeration performer, ResponseUtil response);

	/**
	 * @param subjectId
	 * @param actor
	 * @param successful
	 * @param response
	 */
	void auditMviUnauthenticateRequestEvent(UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response);

	/**
	 * @param userProfile
	 * @param actor
	 * @param successful
	 * @param response
	 */
	void auditMviCorrelateEvent(UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response);


	/**
	 *
	 * @param userProfile
	 * @param actor
	 * @param successful
	 * @param response
	 */
	void auditAccountDeactivateEvent(UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response);

	boolean createLogoutActivity(String userName, Long userProfileId);

	void auditDownloadDataRequestEvent(long userProfileId, ActivityActorTypeEnumeration actor, boolean successful, ActivityActionTypeEnumeration activityActionType, ResponseUtil response);

	void auditUpdateEmailProfileEvent(Long subjectId, String actor, String action);
	
	void auditUpdateEmailProfileEvent(Long userProfileId, String actor, String action, ResponseUtil response, String activityDetails);

	void auditUpdateEmailProfileEvent(Long userProfileId, String actor, String action, ResponseUtil response);

	void auditViewAppointments(String userName, Long userProfileId);
	
	void auditNotificationEvent(Long subjectId, Boolean successful, ActivityActionTypeEnumeration activityActionType, String activityActionDetail);
	
	void auditSendVAHealthSummaryEvent(Long subjectId, Boolean successful, ActivityActionTypeEnumeration activityActionType, String activityActionDetail);

	void auditOnlineAuthenticationEvent(Long subjectId, Boolean successful, String activityName, String actionName,
			String detail, ResponseUtil response);

	void auditDSLogonMappingEvent(Long subjectId, Boolean successful, String actor, String actionType,
			String activityDetailValue, ResponseUtil response);
	
	void createAccountActivityLog(ActivityDTO activity, ResponseUtil response) throws MHVException;
	
	void auditDSLogonMappingActivity(Long subjectId, Boolean successful, String actor,
			String activityType, String actionType, ResponseUtil response);

	void auditUpgradeEvent(Long subjectId, String actor, String actionType, String activityDetailValue,
			ResponseUtil response);

	void auditManualAuthenticationEvent(Long subjectId, Boolean successful, String actionName, String detail,
			ResponseUtil response);

	void auditMviEvent(Long subjectId, String actor, Boolean successful, String activityActionType, String activityType,
			ResponseUtil response);

	void auditDSLogonActivity(Long subjectId, Boolean successful, String actor, String actionType,
			String activityDetailValue, ResponseUtil response);
	
	void createUserActivity(Boolean status, String action, String activityType,ResponseUtil response,Long userProfileId);
}
